
// MCSSharedConstants
// 
// Do not edit this file; edit MCSharedConstants.m4

#ifndef NS_ENUM
#define NS_ENUM(_type, _name) enum _name : _type _name; enum _name : _type
#endif


typedef enum {
    kMCSAuthorizationResultSuccess = 0,
    kMCSAuthorizationResultUnknownError = 1,
    kMCSAuthorizationResultNoDatabase = 2,
    kMCSAuthorizationResultIncorrectLogin = 3,
    kMCSAuthorizationResultExceedLicenses = 5,
    kMCSAuthorizationResultDatabaseServerUnavailable = 6,
    kMCSAuthorizationResultServerSchemaNewer = 10,
    kMCSAuthorizationResultServerSchemaOlder = 11,
    kMCSAuthorizationResultServerVersionNewer = 12,
    kMCSAuthorizationResultServerVersionOlder = 13,
    kMCSAuthorizationResultDatabaseMismatch = 14,
    kMCSAuthorizationResultReplicaAdminRevoked = 19,
    kMCSAuthorizationResultReplicaAdminWipe = 20,
    kMCSAuthorizationResultReplicaResetRequired = 21,
    kMCSAuthorizationResultReplicaRestricted = 22,
    kMCSAuthorizationResultLicenseExpired = 24,
    kMCSAuthorizationResultTrialExpired = 25,
    kMCSAuthorizationConnectionFailed = 26,
    kMCSAuthorizationProcessHung = 27,
    kMCSAuthorizationServiceTemporarilyUnavailable = 214,
    kMCSAuthorizationAccountTemporarilyUnavailable = 215,
    kMCSAuthorizationAccountRequiresUserAction = 216,
    kMCSAuthorizationDeviceReplicaLocked = 217,
    kMCSAuthorizationDeviceSyncStateMismatch = 218,
} MCSAuthorizationResultCode;

typedef enum {
    kMCSAuthorizationResultSchemaMismatch = 4,
    kMCSAuthorizationResultReplicaServerBusy = 23,
} MCSAuthorizationResultCodeDeprecated;

typedef enum {
    kMCSDatabaseListResultSuccess = 1,
    kMCSDatabaseListResultUnknownError = 2,
    kMCSDatabaseListResultDatabaseServerUnavailable = 3,
    kMCSDatabaseListResultVersionIncompatible = 4,
} MCSDatabaseListResultCode;


#pragma mark -
#pragma mark MCClientServer Network Protocol
// Protocol Messages (aka Commands)
extern NSString *kMCSHELLO;
extern NSString *kMCSAuthorizationRequest;
extern NSString *kMCSAuthorizationResponse;
extern NSString *kMCSDatabaselistRequest;
extern NSString *kMCSDatabaselistResponse;
extern NSString *kMCSInfoRequest;
extern NSString *kMCSInfoResponse;


// kMCSAuthorizationRequest payload keys
extern NSString *kMCSAuthVersionKey;
extern NSString *kMCSDatabaseKey;
extern NSString *kMCSSchemaVersionKey;
extern NSString *kMCSUsernameKey;
extern NSString *kMCSPasswordKey;
extern NSString *kMCSServerMirrorKey;
extern NSString *kMCSCloudAccountKey;
extern NSString *kMCSLocaleIdentifierKey;

extern NSString *kMCSReplicaClientUUIDKey;
extern NSString *kMCSReplicaComputerNameKey;
extern NSString *kMCSReplicaLastSyncDateKey;
extern NSString *kMCSReplicaPendingChangesCountKey;


// kMCSAuthorizationResponse payload keys
extern NSString *kMCSAuthorizationResultKey;
extern NSString *kMCSDatabaseCloudAccountKey;
extern NSString *kMCSDatabaseServerPublicAddressKey;
extern NSString *kMCSDatabaseServerPrivateAddressKey;
extern NSString *kMCSDatabaseServerPortKey;
extern NSString *kMCSDatabaseNameKey;
extern NSString *kMCSDatabaseUUIDKey;
extern NSString *kMCSDatabaseUsernameKey;
extern NSString *kMCSDatabasePasswordKey;
extern NSString *kMCSTrialExpiryDateKey;
extern NSString *kMCSDatabaseSchemaKey;
extern NSString *kMCSMoreInfoUrlKey;
extern NSString *kMCSServerDidCheckForPendingChangesKey;
extern NSString *kMCSServerPendingChangeCountKey;


// kMCSDatabaselistRequest payload keys
extern NSString *kMCSDBListVersionKey;


// kMCSDatabaselistResponse payload keys
extern NSString *kMCSProtocolVersionKey;
extern NSString *kMCSDatabaselistResultKey;
extern NSString *kMCSDatabaseDictsKey;


// kMCSInfoResponse keys
extern NSString *kMCSInfoCloudNameKey;
extern NSString *kMCSInfoComputerNameKey;
extern NSString *kMCSInfoComputerImageKey;


// kMCSChangeSetUserInfo keys
extern NSString *kMCSChangeSetInfoLastServerChangelogIDKey;


